package nemosofts.voxradio.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Arrays;

import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Callback;

public class AudioRecorder {

    private final Context context;

    public AudioRecorder(Context context) {
        this.context = context;
    }

    public void startRecording() {
        new AsyncTaskExecutor<Void, Void, StringBuilder>() {

            @Override
            protected void onPreExecute() {
                AudioRecorder.stopRecording();
                Callback.setRecording(true);
                super.onPreExecute();
            }

            @Override
            protected StringBuilder doInBackground(Void voids) {
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    final int randomNumber = ApplicationUtil.getRandomValue(1048) + 2048;
                    String radioTitle = Callback.getArrayListPlay().get(Callback.getPlayPos()).getRadioTitle();
                    String sanitizedTitle = radioTitle.replace(" ", "-")
                            .replaceAll("[^a-zA-Z0-9-]", "");
                    String recordingName = sanitizedTitle + "-Recording-" + randomNumber;

                    String iconsStoragePath = Environment.getExternalStorageDirectory().toString() + File.separator + Environment.DIRECTORY_DOWNLOADS + File.separator + context.getString(R.string.app_name);
                    File sdIconStorageDir = new File(iconsStoragePath);
                    if (!sdIconStorageDir.exists()) {
                        sdIconStorageDir.mkdirs();
                    }
                    String os = sdIconStorageDir + "/" + recordingName + ".mp3";
                    Callback.setInputStream(new URL(Callback.getArrayListPlay().get(Callback.getPlayPos()).getRadioUrl()).openStream());

                    Callback.setFileOutputStream(new FileOutputStream(os));
                    stringBuilder.append("FileOutputStream: ").append(os);

                    while (true) {
                        int l;
                        byte[] buffer = new byte[256];
                        Log.d("buffer.print", "" + Arrays.toString(buffer));
                        while ((l = Callback.getInputStream().read(buffer)) != -1) {
                            Callback.getFileOutputStream().write(buffer, 0, l);
                        }
                    }
                } catch (Exception e) {
                    stringBuilder.append("");
                }
                return stringBuilder;
            }

            @Override
            protected void onPostExecute(StringBuilder s) {
                context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile(new File(String.valueOf(s)))));
            }
        }.execute();
    }

    public static void stopRecording() {
        try {
            Callback.setRecording(false);
            Callback.getFileOutputStream().flush();
            Callback.getFileOutputStream().close();
            Callback.getInputStream().close();
        } catch (Exception e) {
            Log.d("AudioRecorder", "Error closing stream",e);
        }
    }

    public static boolean isRecording() {
        return Callback.isRecording();
    }
}